/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import age.of.civilizations2.jakowski.lukasz.CFG;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;

class SoundsManager {
    private static final String CONSOLE_MUSIC_TITLE = "Scheming_Weasel.ogg";
    protected static boolean isPlayingConsoleMusic = false;
    private static final String START_MUSIC = "Impact_Allegretto.ogg";
    private static final String DEFEAT_MUSIC = "Sudden_Defeat.ogg";
    private List<String> lTitles;
    private Music currentMusic = null;
    private float musicVolume = 0.4f;
    private int iCurrentMusicID = 0;
    private List<Sound> lSounds;
    private float soundsVolume = 0.55f;
    private float masterVolume = 1.0f;
    protected static int SOUND_CLICK;
    protected static int SOUND_CLICK2;
    protected static int SOUND_CLICK3;
    protected static int SOUND_PROVINCE;
    protected static int SOUND_ACTION_MOVE;
    protected static int SOUND_MOVE_ARMY;
    protected static int SOUND_MOVE_ARMY2;
    protected static int SOUND_MOVE_REGROUP;
    protected static int SOUND_INVADE;
    protected static int SOUND_RECRUIT;
    protected static int SOUND_GOLD;
    protected static int SOUND_DIPLOMACY;
    protected static int SOUND_TECHNOLOGY;
    protected static int SOUND_WAR;
    protected static int SOUND_WAR2;
    protected static int SOUND_BUILD;
    protected static int SOUND_PLUNDER;
    protected static int SOUND_CROW;
    protected static int SOUND_SEND;
    protected static int SOUND_SEND2;
    protected static int SOUND_SEND3;
    protected static int SOUND_SEND4;
    protected static int SOUND_ASSIMILATE;
    protected static int SOUND_WORKSHOP;
    protected static int SOUND_FARM;
    protected static int SOUND_PORT;
    protected static int SOUND_SUPPLY;
    protected static int SOUND_LIBRARY;
    protected static int SOUND_RANDOM;
    protected static float PERC_VOLUME_SELECT_PROVINCE;
    protected static float PERC_VOLUME_KEYBOARD;
    private final Random oR = new Random();
    protected Timer timerCurrent;
    protected TimerTask timerCurrentTask;

    static {
        PERC_VOLUME_SELECT_PROVINCE = 0.95f;
        PERC_VOLUME_KEYBOARD = 0.9f;
    }

    protected SoundsManager() {
        this.lTitles = new ArrayList<String>();
        this.lSounds = new ArrayList<Sound>();
        try {
            FileHandle tempFileT = Gdx.files.internal("music/Age_of_Civilizations");
            String tempT = tempFileT.readString();
            String[] tagsSPLITED = tempT.split(";");
            int i = 0;
            while (i < tagsSPLITED.length) {
                this.lTitles.add(tagsSPLITED[i]);
                ++i;
            }
        }
        catch (GdxRuntimeException gdxRuntimeException) {
            // empty catch block
        }
        this.randomizePlayList();
        this.playStartMusic();
        SOUND_CLICK = this.addSound("click.ogg");
        SOUND_CLICK2 = this.addSound("click2.ogg");
        SOUND_CLICK3 = this.addSound("click3.ogg");
        SOUND_PROVINCE = SOUND_CLICK;
        SOUND_MOVE_ARMY = this.addSound("move_army.ogg");
        SOUND_MOVE_ARMY2 = this.addSound("move_army2.ogg");
        SOUND_MOVE_REGROUP = this.addSound("move_army_re.ogg");
        SOUND_GOLD = this.addSound("gold2.ogg");
        SOUND_DIPLOMACY = this.addSound("diplomacy.ogg");
        SOUND_TECHNOLOGY = this.addSound("technology.ogg");
        SOUND_ACTION_MOVE = this.addSound("action_move.ogg");
        SOUND_RECRUIT = this.addSound("metal.ogg");
        SOUND_WAR = this.addSound("war.ogg");
        SOUND_WAR2 = this.addSound("war2.ogg");
        SOUND_BUILD = this.addSound("build.ogg");
        SOUND_SEND = this.addSound("send.ogg");
        SOUND_SEND2 = this.addSound("send2.ogg");
        SOUND_SEND3 = this.addSound("send3.ogg");
        SOUND_SEND4 = this.addSound("send4.ogg");
        SOUND_PLUNDER = this.addSound("plunder.ogg");
        SOUND_CROW = this.addSound("crow.ogg");
        SOUND_ASSIMILATE = this.addSound("assimilate.ogg");
        SOUND_WORKSHOP = this.addSound("workshop.ogg");
        SOUND_FARM = this.addSound("farm.ogg");
        SOUND_PORT = this.addSound("port.ogg");
        SOUND_SUPPLY = this.addSound("supply.ogg");
        SOUND_LIBRARY = this.addSound("library.ogg");
        SOUND_RANDOM = this.addSound("random.ogg");
        this.masterVolume = CFG.settingsManager.VOLUME_MASTER;
        this.setSoundsVolume(CFG.settingsManager.VOLUME_SOUNDS);
        this.setMusicVolume(CFG.settingsManager.VOLUME_MUSIC);
    }

    protected final void randomizePlayList() {
        Random oR = new Random();
        ArrayList<String> tempList = new ArrayList<String>();
        int i = 0;
        while (i < this.lTitles.size()) {
            tempList.add(this.lTitles.get(i));
            ++i;
        }
        this.lTitles.clear();
        while (tempList.size() > 0) {
            int tempR = oR.nextInt(tempList.size());
            this.lTitles.add((String)tempList.get(tempR));
            tempList.remove(tempR);
        }
    }

    protected final void loadNextMusic() {
        this.disposeCurrentMusic();
        ++this.iCurrentMusicID;
        if (this.iCurrentMusicID >= this.lTitles.size()) {
            this.iCurrentMusicID = 0;
        }
        try {
            this.currentMusic = Gdx.audio.newMusic(Gdx.files.internal("music/" + this.lTitles.get(this.iCurrentMusicID)));
            this.currentMusic.setLooping(false);
            this.currentMusic.play();
            this.currentMusic.setVolume(this.musicVolume * this.masterVolume);
            this.currentMusic.setOnCompletionListener(new Music.OnCompletionListener(){

                public void onCompletion(Music music) {
                    SoundsManager.this.loadNextMusic();
                }
            });
            isPlayingConsoleMusic = false;
            try {
                CFG.toast.setInView(this.getCurrentMusicTittle(), CFG.COLOR_TEXT_MODIFIER_NEUTRAL2);
                CFG.toast.setTimeInView(4500);
            }
            catch (NullPointerException nullPointerException) {}
        }
        catch (GdxRuntimeException gdxRuntimeException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected final void loadMusic(int strId) {
        this.disposeCurrentMusic();
        this.iCurrentMusicID = strId;
        try {
            this.currentMusic = Gdx.audio.newMusic(Gdx.files.internal("music/" + this.lTitles.get(strId)));
            this.currentMusic.setLooping(false);
            this.currentMusic.play();
            this.currentMusic.setVolume(this.musicVolume * this.masterVolume);
            this.currentMusic.setOnCompletionListener(new Music.OnCompletionListener(){

                public void onCompletion(Music music) {
                    SoundsManager.this.loadNextMusic();
                }
            });
            isPlayingConsoleMusic = false;
            try {
                CFG.toast.setInView(this.getCurrentMusicTittle(), CFG.COLOR_TEXT_MODIFIER_NEUTRAL2);
                CFG.toast.setTimeInView(4500);
            }
            catch (NullPointerException nullPointerException) {}
        }
        catch (GdxRuntimeException gdxRuntimeException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected final void loadPreviousMusic() {
        this.disposeCurrentMusic();
        --this.iCurrentMusicID;
        if (this.iCurrentMusicID <= 0) {
            this.iCurrentMusicID = this.lTitles.size();
        }
        try {
            this.currentMusic = Gdx.audio.newMusic(Gdx.files.internal("music/" + this.lTitles.get(this.iCurrentMusicID)));
            this.currentMusic.setLooping(false);
            this.currentMusic.play();
            this.currentMusic.setVolume(this.musicVolume * this.masterVolume);
            this.currentMusic.setOnCompletionListener(new Music.OnCompletionListener(){

                public void onCompletion(Music music) {
                    SoundsManager.this.loadPreviousMusic();
                }
            });
            isPlayingConsoleMusic = false;
            try {
                CFG.toast.setInView(this.getCurrentMusicTittle(), CFG.COLOR_TEXT_MODIFIER_NEUTRAL2);
                CFG.toast.setTimeInView(4500);
            }
            catch (NullPointerException nullPointerException) {}
        }
        catch (GdxRuntimeException gdxRuntimeException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected List<String> getlTitles() {
        return this.lTitles;
    }

    protected final void playConsoleMusic() {
        try {
            this.disposeCurrentMusic();
            this.currentMusic = Gdx.audio.newMusic(Gdx.files.internal("music/Scheming_Weasel.ogg"));
            this.currentMusic.setLooping(false);
            this.currentMusic.play();
            this.currentMusic.setVolume(this.musicVolume * this.masterVolume);
            this.currentMusic.setOnCompletionListener(new Music.OnCompletionListener(){

                public void onCompletion(Music music) {
                    SoundsManager.this.loadNextMusic();
                }
            });
            isPlayingConsoleMusic = true;
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (GdxRuntimeException gdxRuntimeException) {
            // empty catch block
        }
    }

    protected int getMusicCurrent() {
        try {
            return (int)this.currentMusic.getPosition();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    protected void setMusicCurrent(float position) {
        this.currentMusic.setPosition(position);
    }

    protected void startCurrentTimer() {
        this.timerCurrent.schedule(this.timerCurrentTask, 500L);
    }

    protected final void playStartMusic() {
        try {
            this.disposeCurrentMusic();
            this.currentMusic = Gdx.audio.newMusic(Gdx.files.internal("music/Impact_Allegretto.ogg"));
            this.currentMusic.setLooping(false);
            this.currentMusic.play();
            this.currentMusic.setVolume(this.musicVolume * this.masterVolume);
            this.currentMusic.setOnCompletionListener(new Music.OnCompletionListener(){

                public void onCompletion(Music music) {
                    SoundsManager.this.loadNextMusic();
                }
            });
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (GdxRuntimeException gdxRuntimeException) {
            // empty catch block
        }
    }

    protected final void disposeCurrentMusic() {
        if (this.currentMusic != null) {
            this.currentMusic.stop();
            this.currentMusic.dispose();
        }
    }

    protected final int addSound(String fileName) {
        this.lSounds.add(Gdx.audio.newSound(Gdx.files.internal("sounds/" + fileName)));
        return this.lSounds.size() - 1;
    }

    protected final void playSound(int id) {
        this.playSound(id, 1.0f);
    }

    protected final void playSound(int id, float fPercOfVolume) {
        this.lSounds.get(id).stop();
        this.lSounds.get(id).play(this.soundsVolume * this.masterVolume * fPercOfVolume);
    }

    protected final int playMoveArmy() {
        int tID = this.oR.nextInt(174) % 2;
        switch (tID) {
            case 1: {
                return SOUND_MOVE_ARMY2;
            }
        }
        return SOUND_MOVE_ARMY;
    }

    protected final String getCurrentMusicTittle() {
        return this.lTitles.get(this.iCurrentMusicID).substring(0, this.lTitles.get(this.iCurrentMusicID).indexOf(".ogg") > 0 ? this.lTitles.get(this.iCurrentMusicID).indexOf(".ogg") : this.lTitles.get(this.iCurrentMusicID).length()).replace("_", " ");
    }

    protected final String getNextMusicTittle() {
        return this.lTitles.get(this.iCurrentMusicID + 1).substring(0, this.lTitles.get(this.iCurrentMusicID).indexOf(".ogg") > 0 ? this.lTitles.get(this.iCurrentMusicID).indexOf(".ogg") : this.lTitles.get(this.iCurrentMusicID).length()).replace("_", " ");
    }

    protected final String getLastMusicTittle() {
        return this.lTitles.get(this.iCurrentMusicID - 1).substring(0, this.lTitles.get(this.iCurrentMusicID).indexOf(".ogg") > 0 ? this.lTitles.get(this.iCurrentMusicID).indexOf(".ogg") : this.lTitles.get(this.iCurrentMusicID).length()).replace("_", " ");
    }

    protected final void setMusicVolume(float nMusicVolume) {
        this.musicVolume = nMusicVolume;
        try {
            this.currentMusic.setVolume(this.musicVolume * this.masterVolume);
            if (this.musicVolume < 0.01f) {
                this.currentMusic.pause();
            } else if (!this.currentMusic.isPlaying()) {
                this.currentMusic.play();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected final float getMusicVolume() {
        return this.musicVolume;
    }

    protected final void setSoundsVolume(float soundsVolume) {
        this.soundsVolume = soundsVolume;
    }

    protected final float getSoundsVolume() {
        return this.soundsVolume;
    }

    protected final void setMasterVolume(float masterVolume) {
        this.masterVolume = masterVolume;
        this.setMusicVolume(this.getMusicVolume());
    }

    protected final float getMasterVolume() {
        return this.masterVolume;
    }

    protected final void dispose() {
        int i = 0;
        while (i < this.lSounds.size()) {
            this.lSounds.get(i).dispose();
            ++i;
        }
        this.currentMusic.dispose();
    }

    protected static final int getSend() {
        switch (CFG.oR.nextInt(4)) {
            case 0: {
                return SOUND_SEND;
            }
            case 1: {
                return SOUND_SEND2;
            }
            case 2: {
                return SOUND_SEND3;
            }
        }
        return SOUND_SEND4;
    }
}

